/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.worlds.together.levelgen;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_156;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2794;
import net.minecraft.class_2874;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3754;
import net.minecraft.class_5216;
import net.minecraft.class_5284;
import net.minecraft.class_5285;
import net.minecraft.class_5317;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_5455;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_6903;
import net.minecraft.class_7059;
import net.minecraft.class_7145;
import org.betterx.worlds.together.WorldsTogether;
import org.betterx.worlds.together.biomesource.BiomeSourceWithConfig;
import org.betterx.worlds.together.biomesource.ReloadableBiomeSource;
import org.betterx.worlds.together.biomesource.config.BiomeSourceConfig;
import org.betterx.worlds.together.chunkgenerator.EnforceableChunkGenerator;
import org.betterx.worlds.together.mixin.common.WorldPresetAccessor;
import org.betterx.worlds.together.world.BiomeSourceWithNoiseRelatedSettings;
import org.betterx.worlds.together.world.BiomeSourceWithSeed;
import org.betterx.worlds.together.world.WorldConfig;
import org.betterx.worlds.together.world.event.WorldBootstrap;
import org.betterx.worlds.together.worldPreset.TogetherWorldPreset;
import org.betterx.worlds.together.worldPreset.WorldPresets;
import org.jetbrains.annotations.ApiStatus;

public class WorldGenUtil {
    public static final String TAG_PRESET = "preset";
    public static final String TAG_GENERATOR = "generator";
    private static final Map<class_5321<class_7145>, Map<class_5321<class_5363>, class_5363>> WORLD_PRESET_MAP = new HashMap<class_5321<class_7145>, Map<class_5321<class_5363>, class_5363>>();

    public static class_5285 createWorldFromPreset(class_5321<class_7145> preset, class_5455 registryAccess, long seed, boolean generateStructures, boolean generateBonusChest) {
        class_5285 settings = ((class_7145)registryAccess.method_30530(class_2378.field_37998).method_40290(preset).comp_349()).method_41585(seed, generateStructures, generateBonusChest);
        for (class_5363 stem : settings.method_28609()) {
            class_1966 class_19662;
            Object bcl;
            class_1966 class_19663 = stem.method_29571().method_12098();
            if (class_19663 instanceof BiomeSourceWithSeed) {
                bcl = (BiomeSourceWithSeed)class_19663;
                bcl.setSeed(seed);
            }
            if (!((class_19662 = stem.method_29571().method_12098()) instanceof BiomeSourceWithNoiseRelatedSettings)) continue;
            bcl = (BiomeSourceWithNoiseRelatedSettings)class_19662;
            class_19662 = stem.method_29571();
            if (!(class_19662 instanceof class_3754)) continue;
            class_3754 noiseGenerator = (class_3754)class_19662;
            bcl.onLoadGeneratorSettings((class_5284)noiseGenerator.method_41541().comp_349());
        }
        return settings;
    }

    public static class_5285 createDefaultWorldFromPreset(class_5455 registryAccess, long seed, boolean generateStructures, boolean generateBonusChest) {
        return WorldGenUtil.createWorldFromPreset(WorldPresets.getDEFAULT(), registryAccess, seed, generateStructures, generateBonusChest);
    }

    @ApiStatus.Internal
    public static Pair<class_5285, class_5455.class_6890> defaultWorldDataSupplier(class_6903<JsonElement> loaderOps, class_5455.class_6890 frozen) {
        class_5285 defaultGen = WorldGenUtil.createDefaultWorldFromPreset((class_5455)frozen);
        class_6903 registryOps = class_6903.method_40414((DynamicOps)JsonOps.INSTANCE, (class_5455)frozen);
        class_5285 worldGenSettings = (class_5285)class_5285.field_24826.encodeStart((DynamicOps)registryOps, (Object)defaultGen).flatMap(json -> class_5285.field_24826.parse((DynamicOps)loaderOps, json)).getOrThrow(false, class_156.method_29188((String)"Error parsing worldgen settings after loading data packs: ", WorldsTogether.LOGGER::error));
        return Pair.of((Object)worldGenSettings, (Object)frozen);
    }

    @ApiStatus.Internal
    public static Map<class_5321<class_5363>, class_5363> getDimensionsWithModData(class_5321<class_7145> preset) {
        Map<class_5321<class_5363>, class_5363> data = WORLD_PRESET_MAP.get(preset);
        if (data == null) {
            return new HashMap<class_5321<class_5363>, class_5363>();
        }
        return data;
    }

    @ApiStatus.Internal
    public static class_6880<class_7145> reloadWithModData(class_6880<class_7145> preset) {
        Object object = preset.comp_349();
        if (object instanceof WorldPresetAccessor) {
            WorldPresetAccessor acc = (WorldPresetAccessor)object;
            Map<class_5321<class_5363>, class_5363> data = WORLD_PRESET_MAP.get(preset.method_40230().orElseThrow());
            if (data != null) {
                acc.bcl_setDimensions(data);
            }
        }
        return preset;
    }

    public static void clearPreloadedWorldPresets() {
        WORLD_PRESET_MAP.clear();
    }

    public static void preloadWorldPresets(class_3300 resourceManager, class_5455.class_6893 writable) {
        WorldGenUtil.clearPreloadedWorldPresets();
        class_2378 registry = writable.method_30530(class_2378.field_37998);
        class_5321 key = class_5317.field_25050;
        class_6903 loaderOps = class_6903.method_40412((DynamicOps)JsonOps.INSTANCE, (class_5455.class_6893)writable, (class_3300)resourceManager);
        class_6880 in = registry.method_40290(key);
        if (in.method_40230().isPresent()) {
            class_6903 registryOps = class_6903.method_40414((DynamicOps)JsonOps.INSTANCE, (class_5455)writable);
            class_5285 settings = WorldGenUtil.createWorldFromPreset((class_5321<class_7145>)((class_5321)in.method_40230().orElseThrow()), (class_5455)writable, class_5819.method_43047().method_43055(), true, false);
            class_5285 worldGenSettings = (class_5285)class_5285.field_24826.encodeStart((DynamicOps)registryOps, (Object)settings).flatMap(json -> class_5285.field_24826.parse((DynamicOps)loaderOps, json)).getOrThrow(false, class_156.method_29188((String)"Error parsing world preset settings  after loading data packs: ", WorldsTogether.LOGGER::error));
            ImmutableMap.Builder map = ImmutableMap.builder();
            for (Map.Entry entry : worldGenSettings.method_28609().method_29722()) {
                map.put((Object)((class_5321)entry.getKey()), (Object)((class_5363)entry.getValue()));
            }
            WORLD_PRESET_MAP.put((class_5321<class_7145>)key, (Map<class_5321<class_5363>, class_5363>)map.build());
        }
    }

    public static class_5285 createDefaultWorldFromPreset(class_5455 registryAccess, long seed) {
        return WorldGenUtil.createDefaultWorldFromPreset(registryAccess, seed, true, false);
    }

    public static class_5285 createDefaultWorldFromPreset(class_5455 registryAccess) {
        return WorldGenUtil.createDefaultWorldFromPreset(registryAccess, class_5819.method_43047().method_43055());
    }

    public static class_2487 getPresetsNbt() {
        return WorldConfig.getCompoundTag("worlds_together", TAG_PRESET);
    }

    public static class_2487 getGeneratorNbt() {
        class_2487 root = WorldConfig.getRootTag("worlds_together");
        if (root.method_10545(TAG_GENERATOR)) {
            return WorldConfig.getCompoundTag("worlds_together", TAG_GENERATOR);
        }
        return null;
    }

    @ApiStatus.Internal
    public static class_5285 repairBiomeSourceInAllDimensions(class_5455 registryAccess, class_5285 settings) {
        Map<class_5321<class_5363>, class_2794> dimensions = TogetherWorldPreset.loadWorldDimensions();
        for (Map.Entry entry : settings.method_28609().method_29722()) {
            class_1966 class_19662;
            boolean didRepair = false;
            class_5321 key = (class_5321)entry.getKey();
            class_5363 loadedStem = (class_5363)entry.getValue();
            class_2794 referenceGenerator = dimensions.get(key);
            if (referenceGenerator instanceof EnforceableChunkGenerator) {
                EnforceableChunkGenerator enforcer = (EnforceableChunkGenerator)referenceGenerator;
                class_2794 loadedChunkGenerator = loadedStem.method_29571();
                if (enforcer.togetherShouldRepair(loadedChunkGenerator)) {
                    settings = enforcer.enforceGeneratorInWorldGenSettings(registryAccess, (class_5321<class_5363>)key, (class_5321<class_2874>)((class_5321)loadedStem.method_29566().method_40230().orElseThrow()), loadedChunkGenerator, settings);
                    didRepair = true;
                } else {
                    class_1966 class_19663 = loadedChunkGenerator.method_12098();
                    if (class_19663 instanceof BiomeSourceWithConfig) {
                        BiomeSourceWithConfig refbs;
                        BiomeSourceWithConfig bs = (BiomeSourceWithConfig)class_19663;
                        class_1966 class_19664 = referenceGenerator.method_12098();
                        if (class_19664 instanceof BiomeSourceWithConfig && !(refbs = (BiomeSourceWithConfig)class_19664).getTogetherConfig().sameConfig((BiomeSourceConfig<?>)bs.getTogetherConfig())) {
                            bs.setTogetherConfig(refbs.getTogetherConfig());
                        }
                    }
                }
            }
            if (didRepair || !((class_19662 = loadedStem.method_29571().method_12098()) instanceof ReloadableBiomeSource)) continue;
            ReloadableBiomeSource reload = (ReloadableBiomeSource)class_19662;
            reload.reloadBiomes();
        }
        return settings;
    }

    public static class_2960 getBiomeID(class_1959 biome) {
        class_2960 id = null;
        class_5455 access = WorldBootstrap.getLastRegistryAccessOrElseBuiltin();
        id = access.method_30530(class_2378.field_25114).method_10221((Object)biome);
        if (id == null) {
            WorldsTogether.LOGGER.error("Unable to get ID for " + biome + ".");
        }
        return id;
    }

    public static class StemContext {
        public final class_6880<class_2874> dimension;
        public final class_2378<class_7059> structureSets;
        public final class_2378<class_5216.class_5487> noiseParameters;
        public final class_6880<class_5284> generatorSettings;

        public StemContext(class_6880<class_2874> dimension, class_2378<class_7059> structureSets, class_2378<class_5216.class_5487> noiseParameters, class_6880<class_5284> generatorSettings) {
            this.dimension = dimension;
            this.structureSets = structureSets;
            this.noiseParameters = noiseParameters;
            this.generatorSettings = generatorSettings;
        }
    }

    public static class Context
    extends StemContext {
        public final class_2378<class_1959> biomes;

        public Context(class_2378<class_1959> biomes, class_6880<class_2874> dimension, class_2378<class_7059> structureSets, class_2378<class_5216.class_5487> noiseParameters, class_6880<class_5284> generatorSettings) {
            super(dimension, structureSets, noiseParameters, generatorSettings);
            this.biomes = biomes;
        }
    }
}

